select E.CodigoOutEmp,
       O.NomeOutEmp,
       E.Seq,
       E.NumeroDcto,
       cast(SUM(OEPS.BASEGPS) as numeric(18,2)) BaseGPS,
       cast(SUM(OEPS.GPSValor) as numeric(18,2)) GPSValor,
       E.GPSOrigem,
       E.CodigoEmpresa,
       E.CodigoEstab,
       E.CodigoLocalCtb, 
       E.ClassifOrgan     
  from  OutraEmpPgto E
  join OutraEmpPgtoServico OEPS
       on  E.CodigoEmpresa = OEPS.CodigoEmpresa
       and E.codigooutemp = OEPS.codigooutemp
       and E.compet = OEPS.compet
       and E.seq = oeps.seq
  LEFT OUTER JOIN OutraEmpEmp OEE
              ON E.CodigoEmpresa = OEE.CodigoEmpresa
             and E.CodigoOutEmp = OEE.CodigoOutEmp
  LEFT OUTER JOIN OutraEmpEmp OEE1
              ON E.CodigoEmpresa = OEE1.CodigoEmpresa
             and E.CodigoOutEmpGPS = OEE1.CodigoOutEmp,
       OutraEmpresa O
 where E.CodigoEmpresa = :pCodigoEmpresa
   and E.Compet = :pCompet
   and (OEE.PossuiGPS = '0'
    or E.CodigoOutEmpGPS is null
    or OEE1.PossuiGPS = '0') 
   and E.CodigoOutEmp = O.CodigoOutEmp
 
 group by E.CodigoOutEmp,
       O.NomeOutEmp,
       E.Seq,
       E.NumeroDcto,
       E.GPSOrigem,
       E.CodigoEmpresa,
       E.CodigoEstab,
       E.CodigoLocalCtb, 
       E.ClassifOrgan
 order by 1