select C.CODIGOEMPRESA,
       C.CodigoFuncContr,
       C.CODIGOESTRUT,
       C.DATAINICIALFERIAS,
       C.seqreciboferias,
       RF.DataFinalFerias,
       RF.DataAbono,
       C.CODIGOBENEF,
       P.NomeBenef,
       MAX(P.PercValor) as PercValor,
       MAX(P.TIPOPGTO) as TIPOPGTO,
       SUM(C.VALORPENSAO) as Valor,
       MAX(RF.DiasFerias) as DiasFerias,
       MAX(RF.DiasAbono) as DiasAbono
from CALCULOPENSAO C
join reciboferias rf on rf.codigoempresa = c.codigoempresa
and rf.CodigoFuncContr = c.CodigoFuncContr
and rf.datainicialferias = c.datainicialferias
and RF.seqreciboferias = C.seqreciboferias

left join PensaoJud P on P.CodigoEmpresa = C.CodigoEmpresa
and P.CodigoFuncContr = C.CodigoFuncContr
and P.CodigoBenef = C.CODIGOBENEF

 where %s
  
group by C.CODIGOEMPRESA,
         C.CodigoFuncContr,
         C.CODIGOESTRUT,
         C.DATAINICIALFERIAS,
         RF.DataFinalFerias,
         RF.DataAbono,
         C.CODIGOBENEF,
         P.NomeBenef,
         C.seqreciboferias
order by 1,
         2,
         3,
         4,
         5