  select cast(sum(Rs.RetencGPS) as numeric(18,2)) RetencGPS
    from Recebimento Rcb
         join RecebimentoServico Rs
           on (Rcb.CodigoEmpresa = Rs.CodigoEmpresa
          and Rcb.CodigoEstab = Rs.CodigoEstab
          and Rcb.Compet = Rs.Compet
          and Rcb.Seq = Rs.Seq)
         left join OutraEmpEmp OEE
                on (Rcb.CodigoEmpresa = OEE.CodigoEmpresa
               and Rcb.CodigoOutEmp = OEE.CodigoOutEmp)
   where Rcb.CodigoEmpresa = :pCodigoEmpresa
     and Rcb.CodigoEstab   = :pCodigoEstab
     and Rcb.Compet        = :pCompet
     and Rcb.CompensarGPS  = :pTipoGps
     and Rcb.ClassifOrgan is null
     and (OEE.PossuiGPS = '0'
      or Rcb.CodigoOutEmp is null)
     
order by 1