 select distinct PA.CodigoEmpresa,
                 PA.CodigoFuncContr,
                 cast(:DataInicial as date) DataInicialCalc,
                 cast(:DataFinal as date) DataFinalCalc,
                 %0:s
                 1 TipoRecibo,
                 PA.DataFinal,
                 PA.SitPeriodo,
                 0 NumeroParcela,
                 cast (null as Date) CompetInicial,
                 0.0 DiasRemun,
                 0 DiasPremio,
                 PA.DiasFaltas,
                 0 DesTaxaSind,
                 0 DescParVale,
                 PA.DiasJaPagos,
                 PA.DiasAbono DiasJaPagosAbono,
                 0 ConcessaoAbono,
                 cast (null as Date) DataInicialFeriasOrig,
				 cast('1' as varchar(1)) PAGAUMTERCO,
                 0 PercentualReciboFerias
            from PeriodoAquisSimul PA,
                 TipoContrato TC,
                 DireitoFerias DF,
                 FuncContrato F
           where PA.CodigoEmpresa = :CodigoEmpresa
             and PA.CodigoFuncContr    = :CodigoFuncContr
             and (:DataInicial between PA.DataInicial and PA.DataFinal
              or (:DataFinal    between PA.DataInicial and PA.DataFinal)
              or (PA.SitPeriodo = 1 and PA.DataFinal <= :DataInicial)
              or exists(select RF.DataInicial
                          from ReciboFeriasSimul RF
                         where RF.CodigoEmpresa = PA.CodigoEmpresa
                           and RF.CodigoFuncContr    = PA.CodigoFuncContr
                           and RF.DataInicial   = PA.DataInicial

						               and ((PA.DataInicial <= :DataFinal
						               and ((F.DataDem is not null
						               and ({TIMESTAMPADD(DAY, - {EXTRACT(DAY, F.DataDem)} + 1, F.DataDem)}) <> (cast(:DataInicial as date)))
						                or F.DataDem is null)
                           and ((RF.DataFinalFerias >= :DataInicial)
                            or RF.TipoRecibo = :TipoRecibo))

							              or (((RF.DataInicialFerias between :DataInicial and :DataFinal)
                            or (RF.DataFinalFerias between :DataInicial and :DataFinal)
                            or (RF.DataInicialFerias < :DataInicial and RF.DataFinalFerias > :DataFinal)
						               	or ({TIMESTAMPADD(DAY, - {EXTRACT(DAY, F.DataDem)} + 1, F.DataDem)}) = (cast(:DataInicial as date))
							             and RF.TipoRecibo = :TipoRecibo)))))
             and F.CodigoEmpresa    = PA.CodigoEmpresa
             and F.CodigoFuncContr  = PA.CodigoFuncContr
             and TC.CodigoTipoContr = F.CodigoTipoContr
             and DF.CodigoDirFerias = TC.CodigoDirFerias
        order by 1, 2, 6, 5, 7

