select FC.CodigoEmpresa,
       FC.CodigoFuncContr,
       SN.CodigoSind,
    SN.DataInicial,
    SN.Escala,
      coalesce(ND.SalarioNormat, SN.NormatBasico) VlrSalNormativo
  from FuncContrato FC
  join FuncPessoa FP
    on FP.CodigoFuncPessoa = FC.CodigoFuncPessoa
 
  join FuncSindicato FS
    on FS.CodigoEmpresa = FC.CodigoEmpresa
   and FS.CodigoFuncContr = FC.CodigoFuncContr
   and FS.DataInicial = (Select Max(FSa.DataInicial)
                           from FuncSindicato FSa
                          where FSa.CodigoEmpresa = FS.CodigoEmpresa
                            and FSa.CodigoFuncContr = FS.CodigoFuncContr
                            and FSa.DataInicial <= :pDataAlteracao)
                            
  join FuncCargo FCA
    on FCA.CodigoEmpresa = FC.CodigoEmpresa
   and FCA.CodigoFuncContr = FC.CodigoFuncContr
   and FCA.DataInicial = (select max(FCAR.DataInicial)
                            from FuncCargo FCAR
                           where FCAR.CodigoEmpresa = FCA.CodigoEmpresa
                             and FCAR.CodigoFuncContr = FCA.CodigoFuncContr
                             and FCAR.DataInicial <= :pDataAlteracao)


  join FuncEscala FE
    on FE.CodigoEmpresa = FC.CodigoEmpresa
   and FE.CodigoFuncContr = FC.CodigoFuncContr
   and FE.DataInicial = (select max(FEs.DataInicial)
                            from funcescala FEs
                           where FEs.CodigoEmpresa = FE.CodigoEmpresa
                             and FEs.CodigoFuncContr = FE.CodigoFuncContr
                             and FEs.DataInicial <= :pDataAlteracao)
    join FuncLocal FL
     on FL.CodigoEmpresa = FC.CodigoEmpresa
    and FL.CodigoFuncContr = FC.CodigoFuncContr
    and FL.DataTransf = (Select Max(FLs.DataTransf)
                           from FuncLocal FLs
                          where FLs.CodigoEmpresa = FL.CodigoEmpresa
                           and FLs.CodigoFuncContr = FL.CodigoFuncContr
                           and FLs.DataTransf <= :pDataAlteracao)
  join SindNormativo SN
    on SN.CodigoSind = FS.CodigoSind
   and SN.DataInicial = :pDataAlteracao 
   and (SN.CodigoSindDissidio = :pCodigoSindDissidio
     or :pCodigoSindDissidio = 0)

  left Join NormativoDet ND
    on ND.CodigoSind  = SN.CodigoSind
   and ND.datainicial = SN.DataInicial
     and (((coalesce(SN.TempoServico, '0') = '0')
    or (SN.TempoServico = '1' and
       ((ND.SinalMeses = 1 and   /* Menor que nÂº meses = 1 */
        cast(({TIMESTAMPDIFF('DAY', cast(:pDataDissidio as date), FC.DataAdm)})  / 30 as integer) < ND.Meses) or
        (ND.SinalMeses = 2 and   /*Maior que nÂº meses = 2 */
        cast(({TIMESTAMPDIFF('DAY', cast(:pDataDissidio as date), FC.DataAdm)}) / 30 as integer) > ND.Meses) or
        (ND.SinalMeses = 3 and   /*Igual a nÂº meses = 3 */
        cast(({TIMESTAMPDIFF('DAY', cast(:pDataDissidio as date), FC.DataAdm)}) / 30 as Integer) = ND.Meses))) )

  and ((coalesce(SN.Idade, '0') = '0')
     or (SN.Idade = '1' and
       ((ND.SinalAnos = 1 and   /* Menor = 1 */
        cast((extract(year from cast(:pDataDissidio as Date))) - (extract(year from(FP.DataNasc))) as integer) < ND.Anos) or
        (ND.SinalAnos = 2 and   /*Maior = 2 */
        cast((extract(year from cast(:pDataDissidio as Date))) - (extract(year from(FP.DataNasc))) as integer) > ND.Anos) or
        (ND.SinalAnos = 3 and   /*Igual = 3 */
        cast((extract(year from cast(:pDataDissidio as Date))) - (extract(year from(FP.DataNasc))) as integer) = ND.Anos))) )

  and ((coalesce(SN.CargoFuncao, '0') = '0') or
       (SN.CargoFuncao = '1' and
       ND.CodigoCargo = FCA.CodigoCargo))

  and  ((coalesce(SN.Categoria, '0')  = '0') or
       (SN.Categoria = '1'  and
       ND.Categoria = FC.Categoria))

  and  ((Coalesce(SN.ESCALA, '0') = '0') or
       (SN.ESCALA = '1' and
       ND.CodigoEscala = FE.CodigoEscala))
    ) 
where %0:s
Order by 
      FC.CodigoEmpresa,
      FC.CodigoFuncContr,
      SN.CodigoSind,
   SN.DataInicial
 