SELECT TP.CodigoTerc,
       T.NomeTerc,
       C.DescrCargo,
       C.CBO,
       TC.DescrTipoContr,
       TP.Seq,
       VB.Valor AS ValorBruto,
       GPS.Valor AS BaseGPS,
       CONTRIBTERC.Valor AS ContribTerc,
       IRR.Valor AS IRRetido,
       TP.DataPgto,
       TP.GPSOrigem,
       TP.PercGPS,
       INSS.Valor AS ValorINSS,
       TP.CodigoImpostoGPS
  FROM Terceiro T
  LEFT OUTER JOIN TipoContrato TC
    ON T.CodigoTipoContr = TC.CodigoTipoContr
  LEFT OUTER JOIN TerceiroPgto TP
    ON TP.CodigoTerc = T.CodigoTerc
  LEFT OUTER JOIN Cargo C
    ON T.CodigoCargo = C.CodigoCargo
  LEFT OUTER JOIN (SELECT SUM(TPS.VALOR) VALOR,
                          TPS.CODIGOEMPRESA,
                          TPS.CodigoTerc,
                          TPS.Compet,
                          TPS.Seq
                     FROM TERCEIROPGTOSERVICO TPS
                    WHERE (TPS.CodigoServico BETWEEN 9000 AND 9013
                           OR
                           TPS.CodigoServico IN (SELECT STER.CODIGOSERVICO
                                                  FROM SERVICOTERC STER
                                                 WHERE STER.TIPOEVENTO = 1
                                                   AND STER.CODIGOSERVICO >= 13000))
                      GROUP BY TPS.CODIGOEMPRESA,
                               TPS.CodigoTerc,
                               TPS.Compet,
                               TPS.Seq) VB
    ON VB.CodigoEmpresa = TP.CodigoEmpresa
   AND VB.CodigoTerc = TP.CodigoTerc
   AND VB.Compet = TP.Compet
   AND VB.Seq = TP.Seq
  LEFT JOIN TERCEIROPGTOSERVICO IRR
    ON IRR.CodigoEmpresa = TP.CodigoEmpresa
   AND IRR.CodigoTerc = TP.CodigoTerc
   AND IRR.Compet = TP.Compet
   AND IRR.Seq = TP.Seq
   AND IRR.CodigoServico IN (9051)
  LEFT JOIN TERCEIROPGTOSERVICO CONTRIBTERC
    ON CONTRIBTERC.CodigoEmpresa = TP.CodigoEmpresa
   AND CONTRIBTERC.CodigoTerc = TP.CodigoTerc
   AND CONTRIBTERC.Compet = TP.Compet
   AND CONTRIBTERC.Seq = TP.Seq
   AND CONTRIBTERC.CodigoServico IN (9057)
  LEFT JOIN TERCEIROPGTOSERVICO GPS
    ON GPS.CodigoEmpresa = TP.CodigoEmpresa
   AND GPS.CodigoTerc = TP.CodigoTerc
   AND GPS.Compet = TP.Compet
   AND GPS.Seq = TP.Seq
   AND GPS.CodigoServico IN (9066)
  LEFT OUTER JOIN (SELECT PGTOINSS.CODIGOEMPRESA,
                          PGTOINSS.CODIGOTERC,
                          PGTOINSS.COMPET,
                          PGTOINSS.SEQ,
                          SUM(PGTOINSS.VALOR) VALOR  
                     FROM TERCEIROPGTOSERVICO PGTOINSS
                    WHERE PGTOINSS.CodigoServico IN (9050, 9064, 9065, 9054, 9055, 9056)
                    GROUP BY PGTOINSS.CODIGOEMPRESA, PGTOINSS.CODIGOTERC, PGTOINSS.COMPET, PGTOINSS.SEQ) INSS 
    ON INSS.CodigoEmpresa = TP.CodigoEmpresa
   AND INSS.CodigoTerc = TP.CodigoTerc
   AND INSS.Compet = TP.Compet
   AND INSS.Seq = TP.Seq
 WHERE TP.CodigoEmpresa = :pCodigoEmpresa
   AND TP.CodigoEstab = :pCodigoEstab
   AND TP.Compet = :pCompet
   AND TP.ClassifOrgan = :pClassifOrgan
   AND TP.CodigoOutEmp = :pCodigoOutEmp
 ORDER BY 1, 2, 6