  select x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         sum(SIR.Valor) IRRetido,
         sum(IRRF.Valor) BaseIrrf,
         sum(SP.Valor) PensaoJud,
         sum(INSS.Valor) DeducaoInss,
         sum(INSSCarne.Valor) INSSCarne,
         sum(RI.Valor) RendimentoIsento,
         0 VoluntarioCopa,
         0 MedicoResidente,
         case x.GPSOrigem 
           when 2 then 'Produtor Rural'
           when 3 then 'Transportador Autnomo'
           when 4 then 'Aluguis'
           when 12 then 'CNGRUA - Minist. conf. relig'
           when 13 then 'Direitos Autorais e Intelectuais'
           else 'Nenhum'
         end DescrRendIsentoOut
    from Terceiro t
    join TerceiroPgto x
      on t.CodigoTerc = x.CodigoTerc
    left join TerceiroPgtoServico SP
      on SP.CodigoEmpresa = x.CODIGOEMPRESA
      and SP.CODIGOTERC = x.CODIGOTERC
      and SP.COMPET = x.COMPET
      and SP.SEQ = x.SEQ
      and SP.CodigoServico = 9053
    left join TerceiroPgtoServico SIR
      on SIR.CodigoEmpresa = x.CODIGOEMPRESA
      and SIR.CODIGOTERC = x.CODIGOTERC
      and SIR.COMPET = x.COMPET
      and SIR.SEQ = x.SEQ
      and SIR.CodigoServico = 9051
    left join TerceiroPgtoServico IRRF
      on IRRF.CodigoEmpresa = x.CODIGOEMPRESA
      and IRRF.CODIGOTERC = x.CODIGOTERC
      and IRRF.COMPET = x.COMPET
      and IRRF.SEQ = x.SEQ
      and IRRF.CodigoServico = 9067
    left join TerceiroPgtoServico RI
      on RI.CodigoEmpresa = x.CODIGOEMPRESA
      and RI.CODIGOTERC = x.CODIGOTERC
      and RI.COMPET = x.COMPET
      and RI.SEQ = x.SEQ
      and RI.CodigoServico = 9068
    left join TerceiroPgtoServico INSS
      on INSS.CodigoEmpresa = x.CODIGOEMPRESA
      and INSS.CODIGOTERC = x.CODIGOTERC
      and INSS.COMPET = x.COMPET
      and INSS.SEQ = x.SEQ
      and INSS.CodigoServico = 9069
    left join TerceiroPgtoServico INSSCarne
      on INSSCarne.CodigoEmpresa = x.CODIGOEMPRESA
      and INSSCarne.CODIGOTERC = x.CODIGOTERC
      and INSSCarne.COMPET = x.COMPET
      and INSSCarne.SEQ = x.SEQ
      and INSSCarne.CodigoServico = 9070 
   where x.DataPgto between :pCompetIni and :pCompetFin
     and x.GPSOrigem not in (5, 6, 7)
     %0:s
group by x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         x.GPSOrigem

union

  select x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         sum(SIR.Valor) IRRetido,
         sum(IRRF.Valor) BaseIrrf,
         sum(SP.Valor) PensaoJud,
         sum(INSS.Valor) DeducaoInss,
         sum(INSSCarne.Valor) INSSCarne,
         0 RendimentoIsento,
         sum(RI.Valor) VoluntarioCopa,
         0 MedicoResidente,
         '' DescrRendIsentoOut
    from Terceiro t
    join TerceiroPgto x
      on t.CodigoTerc = x.CodigoTerc
    left join TerceiroPgtoServico SP
      on SP.CodigoEmpresa = x.CODIGOEMPRESA
      and SP.CODIGOTERC = x.CODIGOTERC
      and SP.COMPET = x.COMPET
      and SP.SEQ = x.SEQ
      and SP.CodigoServico = 9053
    left join TerceiroPgtoServico SIR
      on SIR.CodigoEmpresa = x.CODIGOEMPRESA
      and SIR.CODIGOTERC = x.CODIGOTERC
      and SIR.COMPET = x.COMPET
      and SIR.SEQ = x.SEQ
      and SIR.CodigoServico = 9051
    left join TerceiroPgtoServico IRRF
       on IRRF.CodigoEmpresa = x.CODIGOEMPRESA
       and IRRF.CODIGOTERC = x.CODIGOTERC
       and IRRF.COMPET = x.COMPET
       and IRRF.SEQ = x.SEQ
       and IRRF.CodigoServico = 9067
    left join TerceiroPgtoServico RI
      on RI.CodigoEmpresa = x.CODIGOEMPRESA
      and RI.CODIGOTERC = x.CODIGOTERC
      and RI.COMPET = x.COMPET
      and RI.SEQ = x.SEQ
      and RI.CodigoServico = 9068
    left join TerceiroPgtoServico INSS
      on INSS.CodigoEmpresa = x.CODIGOEMPRESA
      and INSS.CODIGOTERC = x.CODIGOTERC
      and INSS.COMPET = x.COMPET
      and INSS.SEQ = x.SEQ
      and INSS.CodigoServico = 9069
    left join TerceiroPgtoServico INSSCarne
      on INSSCarne.CodigoEmpresa = x.CODIGOEMPRESA
      and INSSCarne.CODIGOTERC = x.CODIGOTERC
      and INSSCarne.COMPET = x.COMPET
      and INSSCarne.SEQ = x.SEQ
      and INSSCarne.CodigoServico = 9070 
   where x.DataPgto between :pCompetIni and :pCompetFin
     and x.GPSOrigem = 6
     %0:s
group by x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         x.GPSOrigem

union

  select x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         sum(SIR.Valor) IRRetido,
         sum(IRRF.Valor) BaseIrrf,
         sum(SP.Valor) PensaoJud,
         sum(INSS.Valor) DeducaoInss,
         sum(INSSCarne.Valor) INSSCarne,
         0 RendimentoIsento,
         0 VoluntarioCopa,
         sum(RI.Valor) MedicoResidente,
         '' DescrRendIsentoOut
    from Terceiro t
    join TerceiroPgto x
      on t.CodigoTerc = x.CodigoTerc
    left join TerceiroPgtoServico SP
      on SP.CodigoEmpresa = x.CODIGOEMPRESA
      and SP.CODIGOTERC = x.CODIGOTERC
      and SP.COMPET = x.COMPET
      and SP.SEQ = x.SEQ
      and SP.CodigoServico = 9053
    left join TerceiroPgtoServico SIR
      on SIR.CodigoEmpresa = x.CODIGOEMPRESA
      and SIR.CODIGOTERC = x.CODIGOTERC
      and SIR.COMPET = x.COMPET
      and SIR.SEQ = x.SEQ
      and SIR.CodigoServico = 9051
    left join TerceiroPgtoServico IRRF
      on IRRF.CodigoEmpresa = x.CODIGOEMPRESA
      and IRRF.CODIGOTERC = x.CODIGOTERC
      and IRRF.COMPET = x.COMPET
      and IRRF.SEQ = x.SEQ
      and IRRF.CodigoServico = 9067
    left join TerceiroPgtoServico RI
      on RI.CodigoEmpresa = x.CODIGOEMPRESA
      and RI.CODIGOTERC = x.CODIGOTERC
      and RI.COMPET = x.COMPET
      and RI.SEQ = x.SEQ
      and RI.CodigoServico = 9068
    left join TerceiroPgtoServico INSS
      on INSS.CodigoEmpresa = x.CODIGOEMPRESA
      and INSS.CODIGOTERC = x.CODIGOTERC
      and INSS.COMPET = x.COMPET
      and INSS.SEQ = x.SEQ
      and INSS.CodigoServico = 9069
    left join TerceiroPgtoServico INSSCarne
      on INSSCarne.CodigoEmpresa = x.CODIGOEMPRESA
      and INSSCarne.CODIGOTERC = x.CODIGOTERC
      and INSSCarne.COMPET = x.COMPET
      and INSSCarne.SEQ = x.SEQ
      and INSSCarne.CodigoServico = 9070 
   where x.DataPgto between :pCompetIni and :pCompetFin
     and x.GPSOrigem = 7
     %0:s
group by x.CodigoEmpresa,
         t.CpfTerc,
         x.CodigoImpostoIRRF,
         x.DataPgto,
         x.NumeroDependIr,
         x.GPSOrigem
   
order by 1, 2, 3, 4, 5