select pc.CodigoEmpresa,
       cast(0 as SmallInt) CodigoOutEmp, 
       cast('0' as VarChar(18)) InscrFedOutEmp, 
       cast(0 as SmallInt) TipoInscrOutEmp, 
       ic.CodigoFuncContr, 
       fp.NomeFunc, 
       fp.PISFunc, 
       pc.Compet, 
       pc.CodigoTipoCalc, 
       pc.DataInicialFolha, 
       pc.DataFinalFolha, 
       cast(sum(case When RE_MULTA.CodigoEmpresa is not null then 0 
           else ic.BaseFGTSNorm end ) as numeric(16,2)) BaseFGTS,
       cast(sum(case When RE_MULTA13.CodigoEmpresa is not null then 0
           else ic.BaseFGTS13 end ) as numeric(16,2)) BaseFGTS13,     
       cast(0 as numeric(16,2)) SemImpostoCalculo
  from PeriodoCalculo pc
  join ImpostoCalculo ic
    on pc.CodigoEmpresa = ic.CodigoEmpresa
   and pc.CodigoPerCalculo = ic.CodigoPerCalculo
  join Estab e
    on  ic.CodigoEmpresa = e.CodigoEmpresa
   and ic.CodigoEstab = e.CodigoEstab
  join FuncContrato f
    on ic.CodigoEmpresa = f.CodigoEmpresa
   and ic.CodigoFuncContr = f.CodigoFuncContr
  join FuncPessoa fp
    on fp.CodigoFuncPessoa = f.CodigoFuncPessoa
  join TipoContrato tc
    on tc.CodigoTipoContr = f.CodigoTipoContr
   and tc.ConstaRais = '1'
  left join OutraEmpEmp oee
    on ic.CodigoEmpresa = oee.CodigoEmpresa 
   and ic.CodigoOutEmp = oee.CodigoOutEmp 
  left join OutraEmpresa oe
    on oee.CodigoOutEmp = oe.CodigoOutEmp
  left join (select RE.codigoempresa,
                    RE.codigofunccontr,
                    R.tiporescisao,
                    R.DataResc,
                    R.datapgtoresc,
                    E.codigoestrut,
                    PC.CodigoPerCalculo
               from rescisao R
               join RescisaoEvento RE
                 on RE.codigoempresa   = R.codigoempresa
                and RE.codigofunccontr = R.codigofunccontr
                and RE.complementar    = R.complementar
               join Evento E
                 on E.codigoevento = RE.codigoevento
               join periodocalculo PC
                 on PC.codigoempresa = R.codigoempresa
              where R.codigoempresa = :pCodigoEmpresa
                and E.codigoestrut in ('98.01.07', '98.01.10')
               and (
          ( 
              (  (R.tiporescisao = 1) and
                 (R.DataResc Between pc.datainicialfolha and pc.datafinalfolha)) or
              (  (R.tiporescisao in (2, 4)) and
                 (R.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha)) or
              (  (R.tiporescisao = 3) and
                 (exists (select 1 from periodoCalculo PCs
                         where PCs.codigoempresa = :pCodigoEmpresa
                           and PCs.codigotipocalc = 7
                           and PCs.CodigoPerCalculo = R.CodigoPerCalculo
                           and PCs.DataPgto between pc.datainicialfolha and pc.datafinalfolha))) ) or
         ( (R.tiporescisao = 5) and
           (R.CodigoPerCalculo = PC.CodigoPerCalculo)))) RE_MULTA
    on RE_MULTA.CodigoEmpresa = IC.CodigoEmpresa
    and RE_MULTA.codigofunccontr = IC.codigofunccontr
    and RE_MULTA.CodigoPerCalculo = PC.CodigoPerCalculo
    
left join (select RE.codigoempresa,
                    RE.codigofunccontr,
                    PC.CodigoPerCalculo,
                    R.tiporescisao,
                    R.DataResc,
                    R.datapgtoresc,
                    E.codigoestrut 
               from rescisao R
               join RescisaoEvento RE
                 on RE.codigoempresa   = R.codigoempresa
                and RE.codigofunccontr = R.codigofunccontr
                and RE.complementar    = R.complementar
               join Evento E 
                 on E.codigoevento = RE.codigoevento
               join periodocalculo PC
                 on PC.codigoempresa = R.codigoempresa               
                 
              where R.codigoempresa = :pCodigoEmpresa
                and E.codigoestrut in ('98.01.07', '98.01.10')
                 and (
           ( ( (R.tiporescisao = 1) and
               (R.DataResc Between pc.datainicialfolha and pc.datafinalfolha)) or 
             ( (R.tiporescisao in (2, 4)) and 
               (R.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha)) or 
             ( (R.tiporescisao = 3) and 
               (exists (select 1 from periodoCalculo P 
                                where p.codigoempresa = :pCodigoEmpresa 
                                  and p.codigotipocalc = 7 
                                  and P.CodigoPerCalculo = R.CodigoPerCalculo
                                  and P.DataPgto between pc.datainicialfolha and pc.datafinalfolha)))) or
           (  (R.tiporescisao = 5) and 
              (R.CodigoPerCalculo = PC.CodigoPerCalculo)))  ) RE_MULTA13
    on RE_MULTA13.codigoempresa = IC.codigoempresa 
   and RE_MULTA13.codigofunccontr = IC.codigofunccontr 
   and RE_MULTA13.CodigoPerCalculo = PC.CodigoPerCalculo

where pc.CodigoEmpresa = :pCodigoEmpresa 
  and pc.Compet between :pDataInicial and :pDataFinal 
  and ic.CodigoEstab = :pCodigoEstab 
  and PC.CodigoTipoCalc <> 9
  and not exists(select 1 from rescisao R
                  where R.codigoempresa   = :pCodigoEmpresa
                    and R.codigofunccontr = F.codigofunccontr
                    and R.TipoRescisao     = 5
                    and R.CodigoPerCalculo = PC.CodigoPerCalculo)
  and (  (ic.CodigoOutEmp is null  or 
          not (  (oee.TipoOutEmp = 1) and 
                 (oee.TipoObra in (1 , 3))))) 
  and (f.DataDem is null or F.DataDem > :pDataDem) 
  and (pc.Compet >= f.DataAdm or 
       f.DataAdm between pc.DataInicialFolha and pc.DataFinalFolha) 
  and not exists(select 1 from rescisao R 
                   join Causademissao CD 
                     on CD.Codigocausa = R.Codigocausa 
                    and CD.Emitegrfc = '1' 
                  where R.codigoempresa   = :pCodigoEmpresa
                    and R.codigofunccontr = IC.codigofunccontr 
                    and R.Tiporescisao    = 4 
                    and (R.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha))
                    
  and ((ic.Comprocesso = '0'
  and (exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso ='1')))
   or (ic.Comprocesso = '1' 
   and (not exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso = '0'))))                        
                    
                    
group by pc.CodigoEmpresa,
         ic.CodigoFuncContr, 
         fp.NomeFunc, 
         fp.PISFunc, 
         pc.Compet, 
         pc.CodigoTipoCalc, 
         pc.DataInicialFolha, 
         pc.DataFinalFolha

union all 

select pc.CodigoEmpresa,
       (oee.CodigoOutEmp) CodigoOutEmp, 
       (oe.InscrFederal) InscrFedOutEmp, 
       (oe.TipoInscr) TipoInscrOutEmp, 
       ic.CodigoFuncContr, 
       fp.NomeFunc, 
       fp.PISFunc, 
       pc.Compet, 
       pc.CodigoTipoCalc, 
       pc.DataInicialFolha, 
       pc.DataFinalFolha, 
       cast(sum(case When RE_MULTA.CodigoEmpresa is not null then 0 
           else ic.BaseFGTSNorm end ) as numeric(16,2)) BaseFGTS, 
       cast(sum(case When RE_MULTA13.CodigoEmpresa is not null then 0 
           else ic.BaseFGTS13 end ) as numeric(16,2)) BaseFGTS13, 
cast(0 as numeric(16,2)) SemImpostoCalculo 
from PeriodoCalculo pc
join ImpostoCalculo ic
  on IC.CodigoEmpresa = PC.CodigoEmpresa
 and IC.CodigoPerCalculo = PC.CodigoPerCalculo
join Estab e
  on e.CodigoEmpresa = ic.CodigoEmpresa
 and e.CodigoEstab = ic.CodigoEstab
join FuncContrato f
  on ic.CodigoEmpresa = f.CodigoEmpresa
 and ic.CodigoFuncContr = f.CodigoFuncContr
join FuncPessoa fp
  on fp.CodigoFuncPessoa = f.CodigoFuncPessoa
join TipoContrato tc
  on f.CodigoTipoContr = tc.CodigoTipoContr
 and tc.ConstaRais = '1'
left join OutraEmpEmp oee
  on oee.CodigoEmpresa = IC.CodigoEmpresa
 and oee.CodigoOutEmp = IC.CodigoOutEmp
join OutraEmpresa oe
 on oe.CodigoOutEmp = oee.CodigoOutEmp
left join (select RE.codigoempresa,
                  RE.codigofunccontr,
                  R.CodigoPerCalculo,
                  R.tiporescisao,
                  R.DataResc,
                  R.datapgtoresc,
                  E.codigoestrut   
             from Rescisao R
             join RescisaoEvento RE
               on RE.codigoempresa   = R.codigoempresa
              and RE.codigofunccontr = R.codigofunccontr
              and RE.complementar    = R.complementar
             join Evento E 
               on E.codigoevento = RE.codigoevento
            where R.CodigoEmpresa = :pCodigoEmpresa
              and E.codigoestrut in ('98.01.07', '98.01.10') ) RE_MULTA
       on RE_MULTA.codigoempresa = IC.codigoempresa 
      and RE_MULTA.codigofunccontr = IC.codigofunccontr 
      and (
            ( (  (RE_MULTA.tiporescisao = 1) and 
                 (RE_MULTA.DataResc Between pc.datainicialfolha and pc.datafinalfolha)) or 
              (  (RE_MULTA.tiporescisao in (2, 4)) and 
                 (RE_MULTA.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha)) or 
              (  (RE_MULTA.tiporescisao = 3) and 
                 (exists (select 1 from periodoCalculo P 
                                  where p.codigoempresa = RE_MULTA.CodigoEmpresa 
                                    and p.codigotipocalc = 7 
                                    and P.CodigoPerCalculo = RE_MULTA.CodigoPerCalculo
                                    and P.DataPgto between pc.datainicialfolha and pc.datafinalfolha)))) or
            ( (RE_MULTA.tiporescisao = 5) and 
              (RE_MULTA.CodigoPerCalculo = IC.CodigoPerCalculo))) 

left join (select RE.codigoempresa,
                  RE.codigofunccontr,
                  R.CodigoPerCalculo,
                  R.tiporescisao,
                  R.DataResc,
                  R.datapgtoresc,
                  E.codigoestrut 
             from Rescisao R
             join RescisaoEvento RE 
               on RE.codigoempresa   = R.codigoempresa
              and RE.codigofunccontr = R.codigofunccontr
              and RE.complementar    = R.complementar
             join Evento E 
               on E.codigoevento = RE.codigoevento
             where R.CodigoEmpresa  = :pCodigoEmpresa
               and E.codigoestrut in ('98.01.07', '98.01.10') ) RE_MULTA13
       on RE_MULTA13.codigoempresa = IC.codigoempresa 
      and RE_MULTA13.codigofunccontr = IC.codigofunccontr 
      and ( (
                 ( (RE_MULTA13.tiporescisao = 1) and 
                   (RE_MULTA13.DataResc Between pc.datainicialfolha and pc.datafinalfolha)) or 
                 ( (RE_MULTA13.tiporescisao in (2, 4)) and 
                   (RE_MULTA13.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha)) or 
                 ( (RE_MULTA13.tiporescisao = 3) and 
                   (exists (select 1 from periodoCalculo P 
                             where p.codigoempresa = RE_MULTA13.CodigoEmpresa 
                               and P.codigotipocalc = 7 
                               and P.CodigoPerCalculo = RE_MULTA13.CodigoPerCalculo
                               and P.DataPgto between pc.datainicialfolha and pc.datafinalfolha)))) or
            ( (RE_MULTA13.tiporescisao = 5) and 
              (RE_MULTA13.CodigoPerCalculo = IC.CodigoPerCalculo))) 
where pc.CodigoEmpresa = :pCodigoEmpresa 
  and pc.Compet between :pDataInicial and :pDataFinal 
  and ic.CodigoEstab = :pCodigoEstab 
  and oee.TipoOutEmp = 1
  and oee.TipoObra in (1,3) 
  and (f.DataDem is null or F.DataDem > :pDataDem) 
  and (pc.Compet >= f.DataAdm or f.DataAdm between pc.DataInicialFolha and pc.DataFinalFolha) 
  and (VALORFGTSNORM+VALORFGTS13+VALORADICFGTSNORM+VALORADICFGTS13+BASEFGTSNORM+BASEFGTS13+
       SALINSSFIXO+SALINSSCONTRIB+BASEFGTS13ADTO+INSSPARTEEMP+INSSENTFINANC+INSSPARTESAT+INSSPARTETERC+
       INSSDIRAUTON+INSSSALEDUCACAO+INSSINCRA+INSSSENAI+INSSSESI+INSSSENAC+INSSSEST+INSSSENAT+INSSSESC+
       INSSSEBRAE+INSSDPC+INSSFAER+INSSSESCOOP+INSSSENAR+BASEINSSFUNC+BASEINSS13FUNC > 0) 
  and not exists(select 1 from rescisao R 
                   join Causademissao CD 
                     on CD.Codigocausa = R.Codigocausa 
                    and CD.Emitegrfc = '1' 
                  where R.codigoempresa   = IC.codigoempresa  
                    and R.codigofunccontr = IC.codigofunccontr 
                    and R.Tiporescisao    = 4 
                    and (R.datapgtoresc Between pc.datainicialfolha and pc.datafinalfolha)) 
                    
 and ((ic.Comprocesso = '0'
  and (exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso ='1')))
   or (ic.Comprocesso = '1' 
   and (not exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso = '0'))))                       
                    
group by pc.CodigoEmpresa,
oee.CodigoOutEmp, 
oe.InscrFederal, 
oe.TipoInscr, 
ic.CodigoFuncContr, 
fp.NomeFunc, 
fp.PISFunc, 
pc.Compet, 
pc.CodigoTipoCalc, 
pc.DataInicialFolha, 
pc.DataFinalFolha

union
select PC.CodigoEmpresa,
       case when (oee.TipoOutEmp = 1) and (oee.TipoObra in (1,3)) then
              FOE.CodigoOutEmp
            else
              0
        end CodigoOutEmp,
       case when (oee.TipoOutEmp = 1) and (oee.TipoObra in (1,3)) then
               OE.InscrFederal
            else
               cast('0' as VarChar(18))
       end  InscrFedOutEmp,
       case when (oee.TipoOutEmp = 1) and (oee.TipoObra in (1,3)) then
              OE.TipoInscr
            else
              0
       end TipoInscrOutEmp,
       FC.CodigoFuncContr, 
       FP.NomeFunc, 
       FP.PISFunc, 
       PC.Compet, 
       PC.CodigoTipoCalc, 
       PC.DataInicialFolha, 
       PC.DataFinalFolha, 
       cast(0 as numeric(16,2)) BaseFGTS, 
       cast(0 as numeric(16,2)) BaseFGTS13, 
       cast(0 as numeric(16,2)) SemImpostoCalculo 
  from Rescisao R 
  join PeriodoCalculo PC 
    on PC.CodigoEmpresa = R.CodigoEmpresa 
 join PeriodoCalculo PCI 
    on PCI.CodigoEmpresa = R.CodigoEmpresa 

  join ImpostoCalculo IC 
    on IC.CodigoEmpresa = R.CodigoEmpresa 
   and IC.CodigoFuncContr = R.CodigoFuncContr 
   and IC.CodigoPerCalculo = PCI.CodigoPerCalculo 

     join FuncContrato FC 
    on FC.CodigoEmpresa = R.CodigoEmpresa 
   and FC.CodigoFuncContr = R.CodigoFuncContr 

  join FuncPessoa FP 
    on FP.CodigoFuncPessoa = FC.CodigoFuncPessoa 

  join TipoContrato TC 
    on TC.CodigoTipoContr = FC.CodigoTipoContr 
   and TC.ConstaRais = '1' 

  join FuncLocal FL 
    on FL.CodigoEmpresa = R.CodigoEmpresa 
   and FL.CodigoFuncContr = R.CodigoFuncContr 
   and FL.Datatransf = (select max(Datatransf) 
                         from FuncLocal Fls 
                        where Fls.CodigoEmpresa = Fl.CodigoEmpresa 
                          and FLs.CodigoFuncContr = FL.CodigoFuncContr 
                          and Fls.datatransf < PC.DataFinalFolha) 
 left  join FuncOutraEmp FOE 
    on FOE.CodigoEmpresa = R.CodigoEmpresa 
   and FOE.CodigoFuncContr = R.CodigoFuncContr 
   and IC.CodigoOutEmp = FOE.CodigoOutEmp 

 left join OutraEmpresa OE 
    on OE.CodigoOutEmp = FOE.CodigoOutEmp 

  left join OutraEmpEmp oee
    on oee.CodigoEmpresa = FOE.CodigoEmpresa
   and oee.CodigoOutEmp = FOE.CodigoOutEmp

 where PC.CodigoEmpresa = :pCodigoEmpresa 
   and PC.Compet between :pDataInicial and :pDataFinal 
   and R.dataresc between PCI.datainicialfolha and PCI.datafinalfolha 
   and R.dataresc between PCI.datainicialfolha and PCI.datafinalfolha 
   and {EXTRACT(year, R.DataResc)} >= 2014 
   and FL.CodigoEstab = :pCodigoEstab 
   and R.DataResc <= :pDataDem 
   and (FOE.codigoempresa is null or 
        FOE.DataInicial = (Select max(FOEs.DataInicial) 
                             from FuncOutraEmp FOEs 
                            where FOEs.CodigoEmpresa = FOE.CodigoEmpresa 
                              and FOEs.CodigoFuncContr = FOE.CodigoFuncContr 
                              and FOE.DataInicial < PC.DataFinalFolha)) 

and ( ( {EXTRACT(year, R.DataResc)} <> {EXTRACT(year, {TIMESTAMPADD(DAY, Coalesce(R.DiasAvInden,0), R.DataResc)})} ) 

  and (((R.tiporescisao = 1) and 
      ({TIMESTAMPADD(DAY, coalesce(R.DiasAvInden, 0), R.DataResc)}  Between PC.DataInicialFolha and PC.DataFinalFolha) )  
         or ( R.tiporescisao in (2, 4) 

        and (((R.DataPgtoResc >= {TIMESTAMPADD(DAY, coalesce(R.DiasAvInden, 0), R.DataResc)} ) and 
            (R.DataPgtoResc  Between PC.DataInicialFolha and PC.DataFinalFolha)) or
            ((R.DataPgtoResc < {TIMESTAMPADD(DAY, coalesce(R.DiasAvInden, 0), R.DataResc)}) and 
            ({TIMESTAMPADD(DAY, coalesce(R.DiasAvInden, 0), R.DataPgtoResc)} Between PC.DataInicialFolha and PC.DataFinalFolha)))
            )))

 and ((ic.Comprocesso = '0'
  and (exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso ='1')))
   or (ic.Comprocesso = '1' 
   and (not exists(Select 1 
               from ImpostoCalculo ICS
              where ICS.CodigoEmpresa = IC.CodigoEmpresa
                and ICS.CodigoPerCalculo = IC.CodigoPerCalculo
                and ICS.CodigoFuncContr = IC.CodigoFuncContr 
                and ICS.CodigoEstab = IC.CodigoEstab 
                and ICS.Comprocesso = '0'))))              
            
order by 1, 2, 5, 8