    Select RE.CodigoEmpresa,
           RE.CodigoFuncContr,
           FS.CodigoSind,
           FS.NomeSind,
           case R.TipoRescisao
             when 1 then
               cast((extract(year from R.DataResc) || '-' || extract(month from R.DataResc) || '-01') as date)
             else
               cast((extract(year from R.DataPgtoResc) || '-' || extract(month from R.DataPgtoResc) || '-01') as date)
           end Compet,
           cast(substr(E.CodigoEstrut, 7, 8) as integer) TipoGRCS,
           Sum(RE.ValorEvento) ValorContrib
      from Rescisao R
      join RescisaoEvento RE
        on R.CodigoEmpresa = RE.CodigoEmpresa
       and R.CodigoFuncContr = RE.CodigoFuncContr
       and R.Complementar = RE.Complementar
      join Evento E
        on E.CodigoEvento = RE.CodigoEvento
      join FuncContrato FC
        on FC.CodigoEmpresa = RE.CodigoEmpresa
       and FC.CodigoFuncContr = RE.CodigoFuncContr
 Inner join FuncSindicato FSa
        on FSa.CodigoEmpresa = R.Codigoempresa
       and FSa.CodigofuncContr = R.CodigofuncContr
       and FSa.DataInicial = (Select Max(FCa.DataInicial)
                                from FuncSindicato FCa
                               where FCa.Codigoempresa = R.Codigoempresa
                                 and FCa.CodigofuncContr = R.CodigofuncContr
                                 and FCa.DataInicial <= R.DataResc)
      join Sindicato FS
        on FS.CodigoSind = FSa.CodigoSind
     where R.CodigoEmpresa = :pCodigoEmpresa
       and R.CodigoFuncContr = :pCodigoFuncContr
    and (E.CodigoEstrut = '97.01.01' or E.CodigoEstrut = '97.01.02' or E.CodigoEstrut = '97.01.03' or E.CodigoEstrut = '97.01.04')
    %0:s
  Group by RE.CodigoEmpresa,
           RE.CodigoFuncContr,
           FS.CodigoSind,
           FS.NomeSind,
           Compet,
           TipoGRCS,
           E.CodigoEstrut