Select E.CodigoEscala,
       E.DESCRESCALA,
    FE.DataInicial,
    CAST(case when FE.REGIMEJOR = 1 then 'Submetidos a Horrio de Trabalho (Cap. II da CLT)'
              when FE.REGIMEJOR = 2 then 'Atividade Externa especificada no Inciso I do Art. 62 da CLT'
              when FE.REGIMEJOR = 3 then 'Funes especficadas no Inciso II do Art. 62 da CLT' end as VARCHAR(60)) REGIMEJOR
  from FuncEscala FE
  join Escala E
    on E.CodigoEscala = FE.CodigoEscala
 where FE.CodigoEmpresa = :pCodigoEmpresa
   and FE.CodigoFuncContr = :pCodigoFuncContr
   and FE.DataInicial = (Select Max(FEa.DataInicial)
                           from FuncEscala FEa
                          where FEa.CodigoEmpresa = FE.CodigoEmpresa
                            and FEa.CodigoFuncContr = FE.CodigoFuncContr
                            and FEa.DataInicial <= :pDataInicial)