Select DISTINCT F.CodigoEmpresa,
       F.CodigoFuncContr,
       FP.NomeFunc,
       FP.ApelidoFunc,
       FP.CPFFunc,
       FP.DataNasc,
       F.DataAdm,
       F.DataDem,
       FL.CodigoEstab,
       FTD.NUMEROCTPS,
       FTD.SERIECTPS,
       FP.PISFUNC,
       FP.NUMERORG,
       FP.TITELEIT,
       FP.CNHFUNC,
       Fp.CATEGCNH,
       Fp.VALIDCNH,
       FP.DDDFone,
       FP.NumeroFone,
       FP.EnderEletr,
       TL.DescrTipoLograd LogradFunc,
       FP.EnderFunc,
       FP.NumeroEnder,
       FP.ComplEnder,
       FP.BairroFunc,
       FP.SiglaEstado,
       FP.CodigoMunic,
       M.NomeMunic,
       FP.CEPFunc
 from FuncContrato F
 Join FuncPessoa FP 
   on FP.CodigoFuncPessoa = F.CodigoFuncPessoa
 join FuncPerCalculo FPC
   on FPC.CodigoEmpresa = F.CodigoEmpresa
  and FPC.CodigoFuncContr = F.CodigoFuncContr
 join PeriodoCalculo PC
   on PC.CodigoEmpresa = FPC.CodigoEmpresa
  and PC.CodigoPerCalculo = FPC.CodigoPerCalculo  
 left join TipoLogradouro TL
   on TL.CodigoTipoLograd = FP.CodigoTipoLograd  
 left join Municipio M
   on M.SiglaEstado = FP.SiglaEstado
  and M.CodigoMunic = FP.CodigoMunic
 left join FuncLocal FL
   on FL.CodigoEmpresa = F.CodigoEmpresa
  and FL.CodigoFuncContr = F.CodigoFuncContr
  and FL.DataTransf = FPC.DataLocal
  
 LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                   FTD.CODIGOFUNCCONTR, 
               MAX(FTD.DATAINICIAL) DATAINICIAL 
             FROM FUNCCTPS FTD 
           GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = F.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = F.CODIGOFUNCCONTR 
 LEFT JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = F.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = F.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL  

LEFT JOIN FUNCLOCALCTB FLC 
  ON FLC.CODIGOEMPRESA = FL.CODIGOEMPRESA
 AND FLC.CODIGOFUNCCONTR = FL.CODIGOFUNCCONTR
 AND EXISTS(SELECT 1
              FROM FUNCLOCALCTB FLCS 
             WHERE FLCS.CODIGOEMPRESA = FLC.CODIGOEMPRESA
               AND FLCS.CODIGOFUNCCONTR = FLC.CODIGOFUNCCONTR
               AND FLCS.DATAOPCAO <= {TIMESTAMPADD(DAY, - {EXTRACT(DAY, {TIMESTAMPADD(MONTH, 1, CAST(PC.COMPET AS DATE))})} , {TIMESTAMPADD(MONTH, 1, CAST(PC.COMPET AS DATE))})}
            HAVING MAX(FLCS.DATAOPCAO) = FLC.DATAOPCAO)  
where 
  %0:s
order by F.CodigoEmpresa,
         F.CodigoFuncContr,
         FL.CodigoEstab