library DespesasGerais;

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, nDMPowerParam_U, npqClass, nActionList_U, nUtilPersonal, FMTBcd,
  DB, nClientDataSet_U, DBClient, Provider, nDataSetProvider_U, SqlExpr,
  nSQLDataSet_U, Math, nUtilForm, nDMSQLDataSet_U, nUtilDB, nUtil, nTipos, 
  nDMDBXDataModel_U, nDialogs, StrUtils, nPowerPInsereLctoCtb_U;

{$E ndl}
{$R *.dfm}

type
  Tdespesasgerais = class(TnPowerPInsereLctoCtb)
  private
  public
    procedure ExecutarInterno; override;
  end;

procedure Tdespesasgerais.ExecutarInterno;
begin
  inherited;

  //Agua
  if StrToFloat(Param('pValorAgua')) > 0 then {Verifica se o valor da gua  maior que zero p/ incluir o lanamento}
  begin
    InserirLcto(1, {Matriz/Filial, fixo na Matriz}
                null, {Lote, fixo NULO}
                null, {Documento, fixo NULO}
                'pData', {Data, informada por parmetro}
                'CB', {Origem, fixo Contabilidade}
                60, {Histrico, fixo 60}
                FormatDateTime('mm/yyyy', TimeStampAdd(SQL_TSI_MONTH, -1, StrToDate(Param('pData')))), {Complemento, ms/ano anterior ao da data de lanamento}
                {Caso desejar-se que no complemento seja o ms/ano da data do lanamento o cdigo dever ser somente:}
                {FormatDateTime('mm/yyyy', StrToDate(Param('pData')))}
                662, {Conta dbito, fixo 662}
                5, {Conta crdito, fixo 5}
                'pValorAgua'); {Valor, informado por parmetro}
  end;

  {Todos os demais lanamentos utilizam essas mesmas regras, sendo a nica modificao a busca do valor
   respectivo quela despesa}

  //Luz
  if StrToFloat(Param('pValorLuz')) > 0 then
  begin
    InserirLcto(1,
                null,
                null,
                'pData',
                'CB',
                58,
                FormatDateTime('mm/yyyy', TimeStampAdd(SQL_TSI_MONTH, -1, StrToDate(Param('pData')))),
                661,
                5,
                'pValorLuz');
  end;

  //Fone
  if StrToFloat(Param('pValorFone')) > 0 then
  begin
    InserirLcto(1,
                null,
                null,
                'pData',
                'CB',
                59,
                FormatDateTime('mm/yyyy', TimeStampAdd(SQL_TSI_MONTH, -1, StrToDate(Param('pData')))),
                663,
                5,
                'pValorFone');
  end;

  //Aluguel
  if StrToFloat(Param('pValorAluguel')) > 0 then
  begin
    InserirLcto(1,
                null,
                null,
                'pData',
                'CB',
                9,
                FormatDateTime('mm/yyyy', TimeStampAdd(SQL_TSI_MONTH, -1, StrToDate(Param('pData')))),
                655,
                5,
                'pValorAluguel');
  end;

  //Condominio
  if StrToFloat(Param('pValorCondominio')) > 0 then
  begin
    InserirLcto(1,
                null,
                null,
                'pData',
                'CB',
                9,
                FormatDateTime('mm/yyyy', StrToDate(Param('pData'))),
                655,
                5,
                'pValorCondominio');
  end;

end;

{codigos que nao devem ser alterados}
var
  fGetClass: TComponentClass;

function GetClass: TComponentClass; stdcall;
begin
  result := fGetClass;
end;

exports
  GetClass;

begin
  fGetClass := Tdespesasgerais;
end.
